<?php 
error_reporting(0);
global $wpo_wcpdf; 
global $WC_booster;
$items = $wpo_wcpdf->get_order_items();
$order = wc_get_order($wpo_wcpdf->export->order->id);
$order_data = $order->get_data();

?>
<style>
    .wc-item-meta li{
        list-style: none;
    }
    .wc-item-meta li p{
        display: inline;
    }
    .wc-item-meta-label{
        display: none;
    }
    .upgrades ul li{
        display: block;
        margin: 0;
        padding: 0;
        font-size: 10px;
    }
    .kit-includes{
        margin-top: 8px;
        margin-bottom: 8px;
    }
    .upgrades ul,
    .kit-includes ul{
        margin: 0;
        padding: 0;
    }
    .upgrades{
        margin-top: 8px;
    }
    .upgrades ul{
        margin-bottom: 8px;
    }
    .kit-includes ul li{
        margin: 0;
        padding: 0;
        list-style: none;
        font-size: 10px;
    }
    .order-details thead th{
        background-color: #76bf42 !important;
        border: 1px solid #76bf42;
        text-align: center;
    }
    .order-details thead th.desc-head{
        text-align: left;
        padding-left: 30px;
    }
    .product-img,
    .product-qty,
    .product-price{
        vertical-align: middle;
        text-align: center;
    }
    .product-description{
        width: 70%;
    }
    .product-img{
        width: 30%;
    }
    .product-qty,.product-price{
        width: 10%;
    }
    .kit-upgrades td{
        vertical-align: middle;
    }
    .order-details tr td{
        border-bottom: 1px solid #adadad;
    }
    table.totals tr td,table.totals tr th{
        border: none;
    }
    .product-description h3{
        font-size:14px;
        margin-bottom:10px;
        margin-top: 10px;
        max-width: 80%;
    }
    .cat-label span{
        margin-right: 10px;
    }
    table{

    }
</style>

<table class="head container">
    <tr>
        <td class="header">
            <img src="<?=get_home_path() . parse_url(wp_get_site_logo('medium'))['path']?>">
        </td>
        <td class="shop-info">
            <div class="shop-name"><h3><?php $this->shop_name(); ?></h3></div>
            <div class="shop-address"><?php $wpo_wcpdf->shop_address(); ?></div>
        </td>
    </tr>
</table>

<h1 class="document-type-label">INVOICE</h1>

<table class="order-data-addresses">
    <tr>
        <td class="address billing-address" style="width: 30%">
            <!-- <h3><?php _e( 'Billing Address:', 'wpo_wcpdf' ); ?></h3> -->
            <h3><?php _e( 'Billing:', 'wpo_wcpdf' ); ?></h3>
                <?php $wpo_wcpdf->billing_address(); ?>
                <div class="billing-email"><?php $wpo_wcpdf->billing_email(); ?></div>
                <div class="billing-phone"><?php $wpo_wcpdf->billing_phone(); ?></div>
        </td>
        <td class="address shipping-address">
                <h3><?php _e( 'Shipping:', 'wpo_wcpdf' ); ?></h3>
                <?php $wpo_wcpdf->shipping_address(); ?>
        </td>
        <td class="order-data">
            <table>
                <?php do_action( 'wpo_wcpdf_before_order_data', $wpo_wcpdf->export->template_type, $wpo_wcpdf->export->order ); ?>
                <?php if ( isset($wpo_wcpdf->settings->template_settings['display_number']) && $wpo_wcpdf->settings->template_settings['display_number'] == 'invoice_number') { ?>
                    <tr class="invoice-number">
                        <th><?php _e( 'Invoice Number:', 'wpo_wcpdf' ); ?></th>
                        <td><?php $wpo_wcpdf->invoice_number(); ?></td>
                    </tr>
                <?php } ?>
                <?php if ( isset($wpo_wcpdf->settings->template_settings['display_date']) && $wpo_wcpdf->settings->template_settings['display_date'] == 'invoice_date') { ?>
                    <tr class="invoice-date">
                        <th><?php _e( 'Invoice Date:', 'wpo_wcpdf' ); ?></th>
                        <td><?php $wpo_wcpdf->invoice_date(); ?></td>
                    </tr>
                <?php } ?>
                <tr class="order-number">
                    <th><?php _e( 'Order Number:', 'wpo_wcpdf' ); ?></th>
                    <td><?php $wpo_wcpdf->order_number(); ?></td>
                </tr>
                <tr class="order-date">
                    <th><?php _e( 'Order Date:', 'wpo_wcpdf' ); ?></th>
                    <td><?php $wpo_wcpdf->order_date(); ?></td>
                </tr>
                <tr class="payment-method">
                    <th><?php _e( 'Payment Method:', 'wpo_wcpdf' ); ?></th>
                    <td><?php $wpo_wcpdf->payment_method(); ?></td>
                </tr>
                <?php do_action( 'wpo_wcpdf_after_order_data', $wpo_wcpdf->export->template_type, $wpo_wcpdf->export->order ); ?>
            </table>
        </td>
    </tr>
</table>

<?php do_action( 'wpo_wcpdf_before_order_details', $wpo_wcpdf->export->template_type, $wpo_wcpdf->export->order ); ?>

<table class="order-details" style="margin-top:-20px;">
    <thead>
        <tr>
            <th class="desc-head"><?php _e('Product Description', 'wpo_wcpdf'); ?></th>
            <th class="product"><?php _e('Product', 'wpo_wcpdf'); ?></th>
            <th class="quantity"><?php _e('Quantity', 'wpo_wcpdf'); ?></th>
            <th class="price"><?php _e('Price', 'wpo_wcpdf'); ?></th>
        </tr>
    </thead>

    <tbody>
    <?php
    $items = $wpo_wcpdf->get_order_items();
    echo count($items);
    if(!empty($items)) :
        foreach( $items as $item_id => $item ) :
        $wc_product = wc_get_product($item['product_id']);
    ?>
        <tr>
            <td class="product-description">
                <h3><?php echo $item['name']; ?></h3>
                <?php 

                $frequencies = $WC_booster->wc_get_product_categories($item['product_id'], 'frequency');
                
                if($frequencies){
                    ?>
                    <div class="cat-label">
                        <span><?=$WC_booster->wc_get_categories_label('frequency')?>:</span>
                        <?= $frequencies[0]->name;?>
                    </div>   
                    <?php
                }
                ?>

                <?php
                
                $coverage = wp_get_product_coverage($item['product_id']);
                if($coverage){
                ?>
                    <div class="cat-label">
                        <span><?=$WC_booster->wc_get_categories_label('coverage')?>: </span>
                        <?= $coverage ?>
                    </div>
                <?php
                }
                ?>
            </td>
            <td class="product-img">
                			 <img height="auto" width="100" src="<?=get_home_path() . parse_url(wp_get_attachment_image_url( get_post_meta($item['product_id'], '_thumbnail_id', true), 'medium' ))['path']?>">

            </td>
            <td class="product-qty">
                <?php echo $item['quantity'];  ?>
            </td>
            <td class="product-price">
                <?php echo wc_price($item["item"]->get_subtotal()); ?>
            </td>
        </tr>
        <tr class="kit-upgrades">
            <td>
            <div class="upgrades">
                <?php
                if($item['variation_id'] && $order->get_status() != 'replace-device'){
                    ?>
                    <h4><?=App\Acf::get('cart_extra', 'option', 'string')?>:</h4>
                    <?php
                    $variation = wc_get_product($item['variation_id']);
                    $attributes = msb_get_cart_item_attributes($variation->get_variation_attributes());
                    foreach ($attributes as $value) {
                        echo '<span>' . $value['label'] . ':</span> ' . $value['value'] . '<br>';
                    }
                }
                // if replacement device only
                if($order->get_status() == 'replace-device'){
                    ?><h2>Replacement Device Only!</h2><?php
                }
                ?>
                </div>
            </td>
            <td class="product-img" style="text-align: left;">
            <div class="kit-includes">
                <?php
                $kit_list = App\Acf::get('kit_list', $item['product_id'], 'array');
                if(!empty($kit_list) && $order->get_status() != 'replace-device'){
                    ?>
                    <h4><?=App\Acf::get('product_including_kit_list_title', 'option', 'string')?>:</h4>
                    <?php
                    foreach($kit_list as $kit_item){
                        echo '<small>' . $kit_item['kit'] . '</small>' . '<br>';
                    }

                }
                ?>
            </div>
            </td>
            <td class="product-qty">
                
            </td>
            <td class="product-price">
                <div style="margin-top: 35px;"><?php for($i=0;$i<count($accs);$i++){
                    echo '<div>'.$accs[$i].'</div>';
                }?></div>
            </td>
        </tr>
        <tr>
            <td colspan="4" style="padding-bottom: 10px;">
                <div><strong>Product Link</strong></div>
                <a href="<?php echo the_permalink($item['product_id']) ?>" target="_blank">
                    <?php echo the_permalink($item['product_id']); ?>
                </a>
            </td>
        </tr>
        <?php endforeach; ?>
    <?php endif; ?>
    </tbody>
    <?php if ( $wpo_wcpdf->get_shipping_notes() ) : ?>
    <tfoot>
        <tr class="no-borders">
            <td colspan="4">
                <div class="customer-notes">
                    <h3><?php _e( 'Customer Notes', 'wpo_wcpdf' ); ?></h3>
                    <?php $wpo_wcpdf->shipping_notes(); ?>
                </div>
            </td>
        </tr>
    </tfoot>
    <?php endif; ?>
</table>

<div style="margin-top: 40px;">
    <table class="totals">
            <tr>
                <td class="no-borders" style="width: 150%;"></td>
                <th class="description"><?= App\Acf::get('checkout_order_details_subtotal', 'option', 'string') ?>:</th>
                <td class="price"><span class="totals-price"><?php echo wc_price($order->get_subtotal()) ?></span></td>
            </tr>
            <?php if(($order->discount_total)>0){?>
            <tr>
                <td class="no-borders" style="width: 150%;"></td>
                <th class="description">Discount:</th>
                <td class="price"><span class="totals-price"><?php echo wc_price($order->discount_total);?></span></td>
            </tr>
             <?php }?>
            <tr>
                <td class="no-borders" style="width: 150%;"></td>
                <th class="description"><?= App\Acf::get('cart_total', 'option', 'string') ?>:</th>
                <td class="price"><span class="totals-price"><?php echo wc_price($order->get_total()) ?></span></td>
            </tr>
    </table>
</div>

<?php do_action( 'wpo_wcpdf_after_order_details', $wpo_wcpdf->export->template_type, $wpo_wcpdf->export->order ); ?>

<?php if ( $wpo_wcpdf->get_footer() ): ?>
    <div id="footer">
        <?php $wpo_wcpdf->footer(); ?>
    </div><!-- #letter-footer -->
<?php endif; ?>
